/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.world.feature;

import dev.toma.gunsrpg.common.block.MilitaryCrateBlock;
import dev.toma.gunsrpg.common.tileentity.ILootGenerator;
import dev.toma.gunsrpg.util.locate.IterableLocator;
import dev.toma.gunsrpg.util.object.LazyLoader;
import java.util.Map;
import java.util.Random;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.block.Block;
import net.minecraft.tags.ITag;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ISeedReader;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.Feature;
import net.minecraft.world.gen.feature.NoFeatureConfig;
import net.minecraftforge.common.Tags;
import net.minecraftforge.registries.ForgeRegistries;

public class LootStashFeature
extends Feature<NoFeatureConfig> {
    private final LazyLoader<Map<MilitaryCrateBlock.BiomeVariant, MilitaryCrateBlock>> MAP = new LazyLoader<Map>(() -> {
        IterableLocator<Object> locator = new IterableLocator<Object>(null);
        Stream<Block> blocks = locator.locateAll((Iterable<Object>)ForgeRegistries.BLOCKS, block -> block instanceof MilitaryCrateBlock);
        return blocks.map(block -> (MilitaryCrateBlock)((Object)((Object)block))).collect(Collectors.toMap(MilitaryCrateBlock::getVariant, Function.identity()));
    });

    public LootStashFeature() {
        super(NoFeatureConfig.field_236558_a_);
    }

    public boolean place(ISeedReader seedReader, ChunkGenerator generator, Random random, BlockPos pos, NoFeatureConfig config) {
        Block block = seedReader.func_180495_p(pos).func_177230_c();
        if (!block.func_203417_a((ITag)Tags.Blocks.STONE) && !block.func_203417_a((ITag)Tags.Blocks.DIRT)) {
            return false;
        }
        Biome biome = seedReader.func_226691_t_(pos);
        float temperature = biome.func_225486_c(pos);
        MilitaryCrateBlock.BiomeVariant variant = MilitaryCrateBlock.BiomeVariant.ARTIC;
        for (MilitaryCrateBlock.BiomeVariant biomeVariant : MilitaryCrateBlock.BiomeVariant.BY_TEMPERATURE) {
            if (!(temperature > biomeVariant.getMinTemperature())) continue;
            variant = biomeVariant;
        }
        MilitaryCrateBlock militaryCrateBlock = this.MAP.get().get((Object)variant);
        seedReader.func_180501_a(pos, militaryCrateBlock.func_176223_P(), 2);
        TileEntity tile = seedReader.func_175625_s(pos);
        if (tile instanceof ILootGenerator) {
            ILootGenerator lootGenerator = (ILootGenerator)tile;
            lootGenerator.generateLoot();
        }
        return true;
    }
}

